/**
 * @description
 * These shims are an attempt to get various accessibility components to work in all versions of the jQuery.
 * New shims are added as issues surface.
 */

(function($) {
  /**
   * @return {Array}
   * @throws {Error}
   */
  function getVersionNumber() {
    if ($) {
      return $.fn.jquery.split(" ")[0].split(".");
    } else {
      throw new Error("jQuery appears to not be loaded!");
    }
  }

  /**
   * @note
   * The preferred method of adding methods to jQuery is:
   *
   * <code>
   *   jQuery.fn.extend({
   *     method: function() {
   *       // your code here
   *     }
   *   });
   * </code>
   *
   * We are not going this route, because the shim is based off of the version
   * of jQuery that is being used.  We don't want to run the risk of prototyping
   * a method already in the namespace.
   */
  var Shims = {
    "3": {
      size: function() {
        $.fn.size = function(options, callback) {
          return $(this).length;
        };
      }
    }
  };

  Object.keys(Shims).forEach(function(key) {
    if (getVersionNumber()[0] >= parseInt(key)) {
      Object.keys(Shims[key]).forEach(function(method) {
        Shims[key][method].call();
      });
    }
  });
})(jQuery);
