/* ========================================================================
 * Bootstrap: collapse.js v3.3.7
 * http://getbootstrap.com/javascript/#collapse
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */

/* jshint latedef: false */

+function ($) {
  'use strict';

  // COLLAPSE PUBLIC CLASS DEFINITION
  // ================================

  var Collapse = function (element, options) {
    this.$element      = $(element)
    this.options       = $.extend({}, Collapse.DEFAULTS, options)
    this.$trigger      = $('[data-toggle="collapse"][href="#' + element.id + '"],' +
                           '[data-toggle="collapse"][data-target="#' + element.id + '"]')
    this.transitioning = null

    if (this.options.parent) {
      this.$parent = this.getParent()
    } else {
      this.addAriaAndCollapsedClass(this.$element, this.$trigger)
    }

    if (this.options.toggle) this.toggle()
  }

  Collapse.VERSION  = '3.3.7'

  Collapse.TRANSITION_DURATION = 350

  Collapse.DEFAULTS = {
    toggle: true
  }

  Collapse.prototype.dimension = function () {
    var hasWidth = this.$element.hasClass('width')
    return hasWidth ? 'width' : 'height'
  }

  Collapse.prototype.show = function () {
    if (this.transitioning || this.$element.hasClass('in')) return

    var activesData
    var actives = this.$parent && this.$parent.children('.panel').children('.in, .collapsing')

    if (actives && actives.length) {
      activesData = actives.data('bs.collapse')
      if (activesData && activesData.transitioning) return
    }

    var startEvent = $.Event('show.bs.collapse')
    this.$element.trigger(startEvent)
    if (startEvent.isDefaultPrevented()) return

    if (actives && actives.length) {
      Plugin.call(actives, 'hide')
      activesData || actives.data('bs.collapse', null)
    }

    var dimension = this.dimension()

    this.$element
      .removeClass('collapse')
      .addClass('collapsing')[dimension](0)
      .attr('aria-expanded', true)

    this.$trigger
      .removeClass('collapsed')
      .attr('aria-expanded', true)

    this.transitioning = 1

    var complete = function () {
      this.$element
        .removeClass('collapsing')
        .addClass('collapse in')[dimension]('')
      this.transitioning = 0
      this.$element
        .trigger('shown.bs.collapse')
    }

    if (!$.support.transition) return complete.call(this)

    var scrollSize = $.camelCase(['scroll', dimension].join('-'))

    this.$element
      .one('bsTransitionEnd', $.proxy(complete, this))
      .emulateTransitionEnd(Collapse.TRANSITION_DURATION)[dimension](this.$element[0][scrollSize])
  }

  Collapse.prototype.hide = function () {
    if (this.transitioning || !this.$element.hasClass('in')) return

    var startEvent = $.Event('hide.bs.collapse')
    this.$element.trigger(startEvent)
    if (startEvent.isDefaultPrevented()) return

    var dimension = this.dimension()

    this.$element[dimension](this.$element[dimension]())[0].offsetHeight

    this.$element
      .addClass('collapsing')
      .removeClass('collapse in')
      .attr('aria-expanded', false)

    this.$trigger
      .addClass('collapsed')
      .attr('aria-expanded', false)

    this.transitioning = 1

    var complete = function () {
      this.transitioning = 0
      this.$element
        .removeClass('collapsing')
        .addClass('collapse')
        .trigger('hidden.bs.collapse')
    }

    if (!$.support.transition) return complete.call(this)

    this.$element
      [dimension](0)
      .one('bsTransitionEnd', $.proxy(complete, this))
      .emulateTransitionEnd(Collapse.TRANSITION_DURATION)
  }

  Collapse.prototype.toggle = function () {
    this[this.$element.hasClass('in') ? 'hide' : 'show']()
  }

  Collapse.prototype.getParent = function () {
    return $(this.options.parent)
      .find('[data-toggle="collapse"][data-parent="' + this.options.parent + '"]')
      .each($.proxy(function (i, element) {
        var $element = $(element)
        this.addAriaAndCollapsedClass(getTargetFromTrigger($element), $element)
      }, this))
      .end()
  }

  Collapse.prototype.addAriaAndCollapsedClass = function ($element, $trigger) {
    var isOpen = $element.hasClass('in')

    $element.attr('aria-expanded', isOpen)
    $trigger
      .toggleClass('collapsed', !isOpen)
      .attr('aria-expanded', isOpen)
  }

  function getTargetFromTrigger($trigger) {
    var href
    var target = $trigger.attr('data-target')
      || (href = $trigger.attr('href')) && href.replace(/.*(?=#[^\s]+$)/, '') // strip for ie7

    return $(target)
  }


  // COLLAPSE PLUGIN DEFINITION
  // ==========================

  function Plugin(option) {
    return this.each(function () {
      var $this   = $(this)
      var data    = $this.data('bs.collapse')
      var options = $.extend({}, Collapse.DEFAULTS, $this.data(), typeof option == 'object' && option)

      if (!data && options.toggle && /show|hide/.test(option)) options.toggle = false
      if (!data) $this.data('bs.collapse', (data = new Collapse(this, options)))
      if (typeof option == 'string') data[option]()
    })
  }

  var old = $.fn.collapse

  $.fn.collapse             = Plugin
  $.fn.collapse.Constructor = Collapse


  // COLLAPSE NO CONFLICT
  // ====================

  $.fn.collapse.noConflict = function () {
    $.fn.collapse = old
    return this
  }


  // COLLAPSE DATA-API
  // =================

  $(document).on('click.bs.collapse.data-api', '[data-toggle="collapse"]', function (e) {
    var $this   = $(this)

    if (!$this.attr('data-target')) e.preventDefault()

    var $target = getTargetFromTrigger($this)
    var data    = $target.data('bs.collapse')
    var option  = data ? 'toggle' : $this.data()

    Plugin.call($target, option)
  })

}(jQuery);

// Collapse Extension
// ===============================

var $colltabs = $('[data-toggle="collapse"]');
$colltabs.each(function(index) {
  var colltab = $(this),
    collpanel = colltab.attr("data-target")
      ? $(colltab.attr("data-target"))
      : $(colltab.attr("href")),
    parent = colltab.attr("data-parent"),
    collparent = parent && $(parent),
    collid = colltab.attr("id") || uniqueId("ui-collapse"),
    parentpanel = collpanel.parent(), // panel containing title and panel body
    parentfirstchild = collparent
      ? collparent.find(".panel.panel-default:first-child")
      : null, // first child of containing accordion
    hasopenpanel = collparent
      ? collparent.find(".panel-collapse.in").length > 0
      : false; // true, if collapse parent has any panels with class 'in'; otherwise, false

  colltab.attr("id", collid);

  if (collparent) {
    colltab.attr({
      "aria-controls": collpanel.attr("id"),
      role: "tab",
      "aria-selected": "false",
      "aria-expanded": "false"
    });
    $(collparent)
      .find("div:not(.collapse,.panel-body), h4")
      .attr("role", "presentation");
    collparent.attr({ role: "tablist", "aria-multiselectable": "true" });
    collpanel.attr({ role: "tabpanel", "aria-labelledby": collid });

    if (!hasopenpanel && parentpanel.is(parentfirstchild)) {
      colltab.attr({ tabindex: "0" });
      collpanel.attr({ tabindex: "-1" });
    } else if (collpanel.hasClass("in")) {
      colltab.attr({
        "aria-selected": "true",
        "aria-expanded": "true",
        tabindex: "0"
      });
      collpanel.attr({ tabindex: "0", "aria-hidden": "false" });
    } else {
      colltab.attr({ tabindex: "-1" });
      collpanel.attr({ tabindex: "-1", "aria-hidden": "true" });
    }
  }
});

var collToggle = $.fn.collapse.Constructor.prototype.toggle;
$.fn.collapse.Constructor.prototype.toggle = function() {
  var prevTab = this.$parent && this.$parent.find('[aria-expanded="true"]'),
    href;

  if (prevTab) {
    var prevPanel =
        prevTab.attr("data-target") ||
        ((href = prevTab.attr("href")) && href.replace(/.*(?=#[^\s]+$)/, "")),
      $prevPanel = $(prevPanel),
      $curPanel = this.$element,
      par = this.$parent,
      curTab;

    if (this.$parent)
      curTab = this.$parent.find(
        '[data-toggle=collapse][href="#' + this.$element.attr("id") + '"]'
      );

    collToggle.apply(this, arguments);

    if ($.support.transition) {
      this.$element.one($.support.transition.end, function() {
        prevTab.attr({
          "aria-selected": "false",
          "aria-expanded": "false",
          tabIndex: "-1"
        });
        $prevPanel.attr({ "aria-hidden": "true", tabIndex: "-1" });

        curTab.attr({
          "aria-selected": "true",
          "aria-expanded": "true",
          tabIndex: "0"
        });

        if ($curPanel.hasClass("in")) {
          $curPanel.attr({ "aria-hidden": "false", tabIndex: "0" });
        } else {
          curTab.attr({ "aria-selected": "false", "aria-expanded": "false" });
          $curPanel.attr({ "aria-hidden": "true", tabIndex: "-1" });
        }
      });
    }
  } else {
    collToggle.apply(this, arguments);
  }
};

$.fn.collapse.Constructor.prototype.keydown = function(e) {
  var $this = $(this),
    $items,
    $tablist = $this.closest("div[role=tablist] "),
    index,
    k = e.which || e.keyCode;

  $this = $(this);
  if (!/(32|37|38|39|40)/.test(k)) return;
  if (k == 32) $this.click();

  $items = $tablist.find("[role=tab]");
  index = $items.index($items.filter(":focus"));

  if (k == 38 || k == 37) index--; // up & left
  if (k == 39 || k == 40) index++; // down & right
  if (index < 0) index = $items.length - 1;
  if (index == $items.length) index = 0;

  $items.eq(index).focus();

  e.preventDefault();
  e.stopPropagation();
};

$(document).on(
  "keydown.collapse.data-api",
  '[data-toggle="collapse"]',
  $.fn.collapse.Constructor.prototype.keydown
);
