/* ========================================================================
 * Bootstrap: carousel.js v3.3.7
 * http://getbootstrap.com/javascript/#carousel
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // CAROUSEL CLASS DEFINITION
  // =========================

  var Carousel = function (element, options) {
    this.$element    = $(element)
    this.$indicators = this.$element.find('.carousel-indicators')
    this.options     = options
    this.paused      = null
    this.sliding     = null
    this.interval    = null
    this.$active     = null
    this.$items      = null

    this.options.keyboard && this.$element.on('keydown.bs.carousel', $.proxy(this.keydown, this))

    this.options.pause == 'hover' && !('ontouchstart' in document.documentElement) && this.$element
      .on('mouseenter.bs.carousel', $.proxy(this.pause, this))
      .on('mouseleave.bs.carousel', $.proxy(this.cycle, this))
  }

  Carousel.VERSION  = '3.3.7'

  Carousel.TRANSITION_DURATION = 600

  Carousel.DEFAULTS = {
    interval: 5000,
    pause: 'hover',
    wrap: true,
    keyboard: true
  }

  Carousel.prototype.keydown = function (e) {
    if (/input|textarea/i.test(e.target.tagName)) return
    switch (e.which) {
      case 37: this.prev(); break
      case 39: this.next(); break
      default: return
    }

    e.preventDefault()
  }

  Carousel.prototype.cycle = function (e) {
    e || (this.paused = false)

    this.interval && clearInterval(this.interval)

    this.options.interval
      && !this.paused
      && (this.interval = setInterval($.proxy(this.next, this), this.options.interval))

    return this
  }

  Carousel.prototype.getItemIndex = function (item) {
    this.$items = item.parent().children('.item')
    return this.$items.index(item || this.$active)
  }

  Carousel.prototype.getItemForDirection = function (direction, active) {
    var activeIndex = this.getItemIndex(active)
    var willWrap = (direction == 'prev' && activeIndex === 0)
                || (direction == 'next' && activeIndex == (this.$items.length - 1))
    if (willWrap && !this.options.wrap) return active
    var delta = direction == 'prev' ? -1 : 1
    var itemIndex = (activeIndex + delta) % this.$items.length
    return this.$items.eq(itemIndex)
  }

  Carousel.prototype.to = function (pos) {
    var that        = this
    var activeIndex = this.getItemIndex(this.$active = this.$element.find('.item.active'))

    if (pos > (this.$items.length - 1) || pos < 0) return

    if (this.sliding)       return this.$element.one('slid.bs.carousel', function () { that.to(pos) }) // yes, "slid"
    if (activeIndex == pos) return this.pause().cycle()

    return this.slide(pos > activeIndex ? 'next' : 'prev', this.$items.eq(pos))
  }

  Carousel.prototype.pause = function (e) {
    e || (this.paused = true)

    if (this.$element.find('.next, .prev').length && $.support.transition) {
      this.$element.trigger($.support.transition.end)
      this.cycle(true)
    }

    this.interval = clearInterval(this.interval)

    return this
  }

  Carousel.prototype.next = function () {
    if (this.sliding) return
    return this.slide('next')
  }

  Carousel.prototype.prev = function () {
    if (this.sliding) return
    return this.slide('prev')
  }

  Carousel.prototype.slide = function (type, next) {
    var $active   = this.$element.find('.item.active')
    var $next     = next || this.getItemForDirection(type, $active)
    var isCycling = this.interval
    var direction = type == 'next' ? 'left' : 'right'
    var that      = this

    if ($next.hasClass('active')) return (this.sliding = false)

    var relatedTarget = $next[0]
    var slideEvent = $.Event('slide.bs.carousel', {
      relatedTarget: relatedTarget,
      direction: direction
    })
    this.$element.trigger(slideEvent)
    if (slideEvent.isDefaultPrevented()) return

    this.sliding = true

    isCycling && this.pause()

    if (this.$indicators.length) {
      this.$indicators.find('.active').removeClass('active')
      var $nextIndicator = $(this.$indicators.children()[this.getItemIndex($next)])
      $nextIndicator && $nextIndicator.addClass('active')
    }

    var slidEvent = $.Event('slid.bs.carousel', { relatedTarget: relatedTarget, direction: direction }) // yes, "slid"
    if ($.support.transition && this.$element.hasClass('slide')) {
      $next.addClass(type)
      $next[0].offsetWidth // force reflow
      $active.addClass(direction)
      $next.addClass(direction)
      $active
        .one('bsTransitionEnd', function () {
          $next.removeClass([type, direction].join(' ')).addClass('active')
          $active.removeClass(['active', direction].join(' '))
          that.sliding = false
          setTimeout(function () {
            that.$element.trigger(slidEvent)
          }, 0)
        })
        .emulateTransitionEnd(Carousel.TRANSITION_DURATION)
    } else {
      $active.removeClass('active')
      $next.addClass('active')
      this.sliding = false
      this.$element.trigger(slidEvent)
    }

    isCycling && this.cycle()

    return this
  }


  // CAROUSEL PLUGIN DEFINITION
  // ==========================

  function Plugin(option) {
    return this.each(function () {
      var $this   = $(this)
      var data    = $this.data('bs.carousel')
      var options = $.extend({}, Carousel.DEFAULTS, $this.data(), typeof option == 'object' && option)
      var action  = typeof option == 'string' ? option : options.slide

      if (!data) $this.data('bs.carousel', (data = new Carousel(this, options)))
      if (typeof option == 'number') data.to(option)
      else if (action) data[action]()
      else if (options.interval) data.pause().cycle()
    })
  }

  var old = $.fn.carousel

  $.fn.carousel             = Plugin
  $.fn.carousel.Constructor = Carousel


  // CAROUSEL NO CONFLICT
  // ====================

  $.fn.carousel.noConflict = function () {
    $.fn.carousel = old
    return this
  }


  // CAROUSEL DATA-API
  // =================

  var clickHandler = function (e) {
    var href
    var $this   = $(this)
    var $target = $($this.attr('data-target') || (href = $this.attr('href')) && href.replace(/.*(?=#[^\s]+$)/, '')) // strip for ie7
    if (!$target.hasClass('carousel')) return
    var options = $.extend({}, $target.data(), $this.data())
    var slideIndex = $this.attr('data-slide-to')
    if (slideIndex) options.interval = false

    Plugin.call($target, options)

    if (slideIndex) {
      $target.data('bs.carousel').to(slideIndex)
    }

    e.preventDefault()
  }

  $(document)
    .on('click.bs.carousel.data-api', '[data-slide]', clickHandler)
    .on('click.bs.carousel.data-api', '[data-slide-to]', clickHandler)

  $(window).on('load', function () {
    $('[data-ride="carousel"]').each(function () {
      var $carousel = $(this)
      Plugin.call($carousel, $carousel.data())
    })
  })

}(jQuery);

// Carousel Extension
// ===============================

$(document).ready(function() {
  $(".carousel").each(function(index) {
    // This function positions a highlight box around the tabs in the tablist to use in focus styling

    function setTablistHighlightBox() {
      var $tab,
        offset,
        height,
        width,
        highlightBox = {};

      highlightBox.top = 0;
      highlightBox.left = 32000;
      highlightBox.height = 0;
      highlightBox.width = 0;
      highlightBox.display = "block";

      for (var i = 0; i < $tabs.length; i++) {
        $tab = $tabs[i];
        offset = $($tab).offset();
        height = $($tab).height();
        width = $($tab).width();

        // console.log(" Top: " + offset.top + " Left: " + offset.left + " Height: " + height + " Width: " + width)

        if (highlightBox.top < offset.top) {
          highlightBox.top = Math.round(offset.top);
        }

        if (highlightBox.height < height) {
          highlightBox.height = Math.round(height);
        }

        if (highlightBox.left > offset.left) {
          highlightBox.left = Math.round(offset.left);
        }

        var w = offset.left - highlightBox.left + Math.round(width);

        if (highlightBox.width < w) {
          highlightBox.width = w;
        }
      } // end for

      highlightBox.display = $tabs.length > 0 ? "block" : "none";

      // console.log("[HIGHLIGHT]  Top: " +  highlightBox.top + " Left: " +  highlightBox.left + " Height: " +  highlightBox.height + " Width: " +  highlightBox.width)

      $tablistHighlight.style.top = highlightBox.top - 2 + "px";
      $tablistHighlight.style.left = highlightBox.left - 2 + "px";
      $tablistHighlight.style.height = highlightBox.height + 7 + "px";
      $tablistHighlight.style.width = highlightBox.width + 8 + "px";
      $tablistHighlight.style.display = highlightBox.display;
    } // end function

    var $this = $(this),
      $prev = $this.find('[data-slide="prev"]'),
      $next = $this.find('[data-slide="next"]'),
      $tablist = $this.find(".carousel-indicators"),
      $tabs = $this.find(".carousel-indicators li"),
      $tabpanels = $this.find(".item"),
      $tabpanel,
      $tablistHighlight,
      $pauseCarousel,
      $complementaryLandmark,
      $tab,
      $is_paused = false,
      offset,
      height,
      width,
      i,
      id_title = "id_title",
      id_desc = "id_desc";

    console.log("Number of indicators: ", $tabs.length);

    $tablist.attr("role", "tablist");

    $tabs.focus(function() {
      $this.carousel("pause");
      $is_paused = true;
      $pauseCarousel.innerHTML = "Play Carousel";
      $(this)
        .parent()
        .addClass("active");
      //          $(this).addClass('focus')
      setTablistHighlightBox();
      $($tablistHighlight).addClass("focus");
      $(this)
        .parents(".carousel")
        .addClass("contrast");
    });

    $tabs.blur(function(event) {
      $(this)
        .parent()
        .removeClass("active");
      //          $(this).removeClass('focus')
      $($tablistHighlight).removeClass("focus");
      $(this)
        .parents(".carousel")
        .removeClass("contrast");
    });

    for (i = 0; i < $tabpanels.length; i++) {
      $tabpanel = $tabpanels[i];
      $tabpanel.setAttribute("role", "tabpanel");
      $tabpanel.setAttribute("id", "tabpanel-" + index + "-" + i);
      $tabpanel.setAttribute("aria-labelledby", "tab-" + index + "-" + i);
    }

    if (typeof $this.attr("role") !== "string") {
      $this.attr("role", "complementary");
      $this.attr("aria-labelledby", id_title);
      $this.attr("aria-describedby", id_desc);
      $this.prepend(
        '<p  id="' +
          id_desc +
          '" class="sr-only">A carousel is a rotating set of images, rotation stops on keyboard focus on carousel tab controls or hovering the mouse pointer over images.  Use the tabs or the previous and next buttons to change the displayed slide.</p>'
      );
      $this.prepend(
        '<h2 id="' +
          id_title +
          '" class="sr-only">Carousel content with ' +
          $tabpanels.length +
          " slides.</h2>"
      );
    }

    for (i = 0; i < $tabs.length; i++) {
      $tab = $tabs[i];

      $tab.setAttribute("role", "tab");
      $tab.setAttribute("id", "tab-" + index + "-" + i);
      $tab.setAttribute("aria-controls", "tabpanel-" + index + "-" + i);

      var tpId = "#tabpanel-" + index + "-" + i;
      var caption = $this
        .find(tpId)
        .find("h1")
        .text();

      if (typeof caption !== "string" || caption.length === 0)
        caption = $this.find(tpId).text();
      if (typeof caption !== "string" || caption.length === 0)
        caption = $this
          .find(tpId)
          .find("h3")
          .text();
      if (typeof caption !== "string" || caption.length === 0)
        caption = $this
          .find(tpId)
          .find("h4")
          .text();
      if (typeof caption !== "string" || caption.length === 0)
        caption = $this
          .find(tpId)
          .find("h5")
          .text();
      if (typeof caption !== "string" || caption.length === 0)
        caption = $this
          .find(tpId)
          .find("h6")
          .text();
      if (typeof caption !== "string" || caption.length === 0)
        caption = "no title";

      //          console.log("CAPTION: " + caption )

      var tabName = document.createElement("span");
      tabName.setAttribute("class", "sr-only");
      tabName.innerHTML = "Slide " + (i + 1);
      if (caption) tabName.innerHTML += ": " + caption;
      $tab.appendChild(tabName);
    }

    // create div for focus styling of tablist
    $tablistHighlight = document.createElement("div");
    $tablistHighlight.className = "carousel-tablist-highlight";
    document.body.appendChild($tablistHighlight);

    // create button for screen reader users to stop rotation of carousel

    // create button for screen reader users to pause carousel for virtual mode review
    $complementaryLandmark = document.createElement("aside");
    $complementaryLandmark.setAttribute("class", "carousel-aside-pause");
    $complementaryLandmark.setAttribute(
      "aria-label",
      "carousel pause/play control"
    );
    $this.prepend($complementaryLandmark);

    $pauseCarousel = document.createElement("button");
    $pauseCarousel.className = "carousel-pause-button";
    $pauseCarousel.innerHTML = "Pause Carousel";
    $pauseCarousel.setAttribute(
      "title",
      "Pause/Play carousel button can be used by screen reader users to stop carousel animations"
    );
    $($complementaryLandmark).append($pauseCarousel);

    $($pauseCarousel).click(function() {
      if ($is_paused) {
        $pauseCarousel.innerHTML = "Pause Carousel";
        $this.carousel("cycle");
        $is_paused = false;
      } else {
        $pauseCarousel.innerHTML = "Play Carousel";
        $this.carousel("pause");
        $is_paused = true;
      }
    });
    $($pauseCarousel).focus(function() {
      $(this).addClass("focus");
    });

    $($pauseCarousel).blur(function() {
      $(this).removeClass("focus");
    });

    setTablistHighlightBox();

    $(window).resize(function() {
      setTablistHighlightBox();
    });

    // Add space bar behavior to prev and next buttons for SR compatibility
    $prev.attr("aria-label", "Previous Slide");
    $prev.keydown(function(e) {
      var k = e.which || e.keyCode;
      if (/(13|32)/.test(k)) {
        e.preventDefault();
        e.stopPropagation();
        $prev.trigger("click");
      }
    });

    $prev.focus(function() {
      $(this)
        .parents(".carousel")
        .addClass("contrast");
    });

    $prev.blur(function() {
      $(this)
        .parents(".carousel")
        .removeClass("contrast");
    });

    $next.attr("aria-label", "Next Slide");
    $next.keydown(function(e) {
      var k = e.which || e.keyCode;
      if (/(13|32)/.test(k)) {
        e.preventDefault();
        e.stopPropagation();
        $next.trigger("click");
      }
    });

    $next.focus(function() {
      $(this)
        .parents(".carousel")
        .addClass("contrast");
    });

    $next.blur(function() {
      $(this)
        .parents(".carousel")
        .removeClass("contrast");
    });

    $(".carousel-inner a").focus(function() {
      $(this)
        .parents(".carousel")
        .addClass("contrast");
    });

    $(".carousel-inner a").blur(function() {
      $(this)
        .parents(".carousel")
        .removeClass("contrast");
    });

    $tabs.each(function() {
      var item = $(this);
      if (item.hasClass("active")) {
        item.attr({ "aria-selected": "true", tabindex: "0" });
      } else {
        item.attr({ "aria-selected": "false", tabindex: "-1" });
      }
    });
  });
});

var slideCarousel = $.fn.carousel.Constructor.prototype.slide;
$.fn.carousel.Constructor.prototype.slide = function(type, next) {
  var $element = this.$element,
    $active = $element.find("[role=tabpanel].active"),
    $next = next || $active[type](),
    $tab,
    $tab_count = $element.find("[role=tabpanel]").size(),
    $prev_side = $element.find('[data-slide="prev"]'),
    $next_side = $element.find('[data-slide="next"]'),
    $index = 0,
    $prev_index = $tab_count - 1,
    $next_index = 1,
    $id;

  if ($next && $next.attr("id")) {
    $id = $next.attr("id");
    $index = $id.lastIndexOf("-");
    if ($index >= 0) $index = parseInt($id.substring($index + 1), 10);

    $prev_index = $index - 1;
    if ($prev_index < 1) $prev_index = $tab_count - 1;

    $next_index = $index + 1;
    if ($next_index >= $tab_count) $next_index = 0;
  }

  $prev_side.attr(
    "aria-label",
    "Show slide " + ($prev_index + 1) + " of " + $tab_count
  );
  $next_side.attr(
    "aria-label",
    "Show slide " + ($next_index + 1) + " of " + $tab_count
  );

  slideCarousel.apply(this, arguments);

  $active.one("bsTransitionEnd", function() {
    var $tab;

    $tab = $element.find('li[aria-controls="' + $active.attr("id") + '"]');
    if ($tab) $tab.attr({ "aria-selected": false, tabIndex: "-1" });

    $tab = $element.find('li[aria-controls="' + $next.attr("id") + '"]');
    if ($tab) $tab.attr({ "aria-selected": true, tabIndex: "0" });
  });
};

var $this;
$.fn.carousel.Constructor.prototype.keydown = function(e) {
  $this = $this || $(this);
  if (this instanceof Node) $this = $(this);

  function selectTab(index) {
    if (index >= $tabs.length) return;
    if (index < 0) return;

    $carousel.carousel(index);
    setTimeout(function() {
      $tabs[index].focus();
      // $this.prev().focus()
    }, 150);
  }

  var $carousel = $(e.target).closest(".carousel"),
    $tabs = $carousel.find("[role=tab]"),
    k = e.which || e.keyCode,
    index;

  if (!/(37|38|39|40)/.test(k)) return;

  index = $tabs.index($tabs.filter(".active"));
  if (k == 37 || k == 38) {
    //  Up
    index--;
    selectTab(index);
  }

  if (k == 39 || k == 40) {
    // Down
    index++;
    selectTab(index);
  }

  e.preventDefault();
  e.stopPropagation();
};
$(document).on(
  "keydown.carousel.data-api",
  "li[role=tab]",
  $.fn.carousel.Constructor.prototype.keydown
);
