* Program............: C:\DBASE\TABLE14.FRG
* Date...............: 7-16-92
* Versions...........: dBASE IV, Report 1.1
*
* Notes:
* ------
* Prior to running this procedure with the DO command
* it is necessary use LOCATE because the CONTINUE
* statement is in the main loop.
*
*-- Parameters
PARAMETERS gl_noeject, gl_plain, gl_summary, gc_heading, gc_extra
** The first three parameters are of type Logical.
** The fourth parameter is a string.  The fifth is extra.
PRIVATE _peject, _wrap

*-- Test for no records found
IF EOF() .OR. .NOT. FOUND()
   RETURN
ENDIF

*-- turn word wrap mode off
_wrap=.F.

IF _plength < (_pspacing * 9 + 1) + 1 + 2
   SET DEVICE TO SCREEN
   DEFINE WINDOW gw_report FROM 7,17 TO 11,62 DOUBLE
   ACTIVATE WINDOW gw_report
   @ 0,1 SAY "Increase the page length for this report."
   @ 2,1 SAY "Press any key ..."
   x=INKEY(0)
   DEACTIVATE WINDOW gw_report
   RELEASE WINDOW gw_report
   RETURN
ENDIF

_plineno=0          && set lines to zero
*-- NOEJECT parameter
IF gl_noeject
   IF _peject="BEFORE"
      _peject="NONE"
   ENDIF
   IF _peject="BOTH"
      _peject="AFTER"
   ENDIF
ENDIF

*-- Set-up environment
ON ESCAPE DO Prnabort
IF SET("TALK")="ON"
   SET TALK OFF
   gc_talk="ON"
ELSE
   gc_talk="OFF"
ENDIF
gc_space=SET("SPACE")
SET SPACE OFF
gc_time=TIME()      && system time for predefined field
gd_date=DATE()      && system date  "    "    "     "
gl_fandl=.F.        && first and last page flag
gl_prntflg=.T.      && Continue printing flag
gl_widow=.T.        && flag for checking widow bands
gn_length=LEN(gc_heading)  && store length of the HEADING
gn_level=2          && current band being processed
gn_page=_pageno     && grab current page number
gn_pspace=_pspacing && get current print spacing


*-- Set up procedure for page break
gn_atline=_plength - 1
ON PAGE AT LINE gn_atline EJECT PAGE

*-- Print Report

PRINTJOB

IF gl_plain
   ON PAGE AT LINE gn_atline DO Pgplain
ELSE
   ON PAGE AT LINE gn_atline DO Pgfoot
ENDIF

DO Pghead

gl_fandl=.T.        && first physical page started

*-- File Loop
DO WHILE FOUND() .AND. .NOT. EOF() .AND. gl_prntflg
   gn_level=0
   *-- Detail lines
   IF gl_summary
      DO Upd_Vars
   ELSE
      DO __Detail
   ENDIF
   gl_widow=.T.         && enable widow checking
   CONTINUE
ENDDO

IF gl_prntflg
ELSE
   DO Reset
   RETURN
ENDIF

ON PAGE

ENDPRINTJOB

DO Reset
RETURN
* EOP: C:\DBASE\TABLE14.FRG

*-- Update summary fields and/or calculated fields.
PROCEDURE Upd_Vars
RETURN
* EOP: Upd_Vars

*-- Set flag to get out of DO WHILE loop when escape is pressed.
PROCEDURE Prnabort
gl_prntflg=.F.
RETURN
* EOP: Prnabort

PROCEDURE Pghead
?
?? "Table 14." AT 0,;
 ;
"Mineralogical remarks and chemical composition of various apatite grai";
+ "ns identified in the heavy-mineral-concentrate test study samples by";
AT 11
?

*-- Print HEADING parameter ie. REPORT FORM <name> HEADING <expC>
IF .NOT. gl_plain .AND. gn_length > 0
   ?? gc_heading FUNCTION "I;V"+LTRIM(STR(_rmargin-_lmargin))
   ?
ENDIF
?? "electron microprobe analysis" AT 11
?
?
?? ;
"";
+ "";
+ "";
AT 0
?
?? "MDNR" AT 1,;
 "Heavy-Mineral" AT 7,;
 "Grain" AT 31,;
 "Weight % of Elements" AT 81,;
 "Weight % of Oxides" AT 120
?
?? "Sample" AT 0,;
 "Concentrate" AT 8,;
 "Size in" AT 30,;
 "Total" AT 154
?
?? "Number" AT 0,;
 "Fraction" AT 9,;
 "Mineral" AT 20,;
 "Micrometers" AT 29,;
 "Remarks" AT 49,;
 "F" AT 79,;
 "F=O" AT 85,;
 "Cl" AT 92,;
 "Cl=O" AT 98,;
 "BaO" AT 106,;
 "CaO" AT 113,;
 "FeO" AT 120,;
 "MgO" AT 127,;
 "MnO" AT 134,;
 "P" AT 140,;
 "2" STYLE "L" ,;
 "O" 
?? "5" STYLE "L" ,;
 "SrO" AT 148,;
 "Wt. %" AT 154
?
?? ;
"";
+ "";
+ "";
AT 0
?
RETURN
* EOP: Pghead


PROCEDURE __Detail
IF gn_pspace < gn_atline - (_pspacing * 9 + 1)
   IF gl_widow .AND. _plineno+gn_pspace > gn_atline + 1
      EJECT PAGE
   ENDIF
ENDIF
DO Upd_Vars
?? Dnr_s_no FUNCTION "T" AT 0,;
 C_fraction FUNCTION "T" AT 11,;
 A_mineral FUNCTION "T" AT 20,;
 A_grain_sz FUNCTION "T" AT 30,;
 A_remarks FUNCTION "V34" AT 41,;
 F FUNCTION "T" AT 77,;
 F_equal_o FUNCTION "T" AT 84,;
 Cl FUNCTION "T" AT 91,;
 Cl_equal_o FUNCTION "T" AT 98,;
 Bao FUNCTION "T" AT 105,;
 Cao FUNCTION "T" AT 112,;
 Feo FUNCTION "T" AT 119,;
 Mgo FUNCTION "T" AT 126,;
 Mno FUNCTION "T" AT 133,;
 P2o5 FUNCTION "T" AT 140,;
 Sro FUNCTION "T" AT 147,;
 Prct_total FUNCTION "T" AT 154
?
RETURN
* EOP: __Detail


PROCEDURE Pgfoot
PRIVATE _box
gl_widow=.F.         && disable widow checking
EJECT PAGE
*-- is the page number greater than the ending page
IF _pageno > _pepage
   GOTO BOTTOM
   SKIP
   gn_level=0
ENDIF
IF .NOT. gl_plain .AND. gl_fandl
   _pspacing=gn_pspace
   DO Pghead
ENDIF
RETURN
* EOP: Pgfoot

*-- Process page break when PLAIN option is used.
PROCEDURE Pgplain
PRIVATE _box
EJECT PAGE
RETURN
* EOP: Pgplain

*-- Reset dBASE environment prior to calling report
PROCEDURE Reset
SET SPACE &gc_space.
SET TALK &gc_talk.
ON ESCAPE
ON PAGE
RETURN
* EOP: Reset

