* Program............: C:\DBASE\TABLE12B.FRG
* Date...............: 7-16-92
* Versions...........: dBASE IV, Report 1.1
*
* Notes:
* ------
* Prior to running this procedure with the DO command
* it is necessary use LOCATE because the CONTINUE
* statement is in the main loop.
*
*-- Parameters
PARAMETERS gl_noeject, gl_plain, gl_summary, gc_heading, gc_extra
** The first three parameters are of type Logical.
** The fourth parameter is a string.  The fifth is extra.
PRIVATE _peject, _wrap

*-- Test for no records found
IF EOF() .OR. .NOT. FOUND()
   RETURN
ENDIF

*-- turn word wrap mode off
_wrap=.F.

IF _plength < (_pspacing * 11 + 1) + (_pspacing * 2 + 1) + 2
   SET DEVICE TO SCREEN
   DEFINE WINDOW gw_report FROM 7,17 TO 11,62 DOUBLE
   ACTIVATE WINDOW gw_report
   @ 0,1 SAY "Increase the page length for this report."
   @ 2,1 SAY "Press any key ..."
   x=INKEY(0)
   DEACTIVATE WINDOW gw_report
   RELEASE WINDOW gw_report
   RETURN
ENDIF

_plineno=0          && set lines to zero
*-- NOEJECT parameter
IF gl_noeject
   IF _peject="BEFORE"
      _peject="NONE"
   ENDIF
   IF _peject="BOTH"
      _peject="AFTER"
   ENDIF
ENDIF

*-- Set-up environment
ON ESCAPE DO Prnabort
IF SET("TALK")="ON"
   SET TALK OFF
   gc_talk="ON"
ELSE
   gc_talk="OFF"
ENDIF
gc_space=SET("SPACE")
SET SPACE OFF
gc_time=TIME()      && system time for predefined field
gd_date=DATE()      && system date  "    "    "     "
gl_fandl=.F.        && first and last page flag
gl_prntflg=.T.      && Continue printing flag
gl_widow=.T.        && flag for checking widow bands
gn_length=LEN(gc_heading)  && store length of the HEADING
gn_level=2          && current band being processed
gn_page=_pageno     && grab current page number
gn_pspace=_pspacing && get current print spacing


*-- Set up procedure for page break
gn_atline=_plength - (_pspacing * 2 + 1)
ON PAGE AT LINE gn_atline EJECT PAGE

*-- Print Report

PRINTJOB

IF gl_plain
   ON PAGE AT LINE gn_atline DO Pgplain
ELSE
   ON PAGE AT LINE gn_atline DO Pgfoot
ENDIF

DO Pghead

gl_fandl=.T.        && first physical page started

*-- File Loop
DO WHILE FOUND() .AND. .NOT. EOF() .AND. gl_prntflg
   gn_level=0
   *-- Detail lines
   IF gl_summary
      DO Upd_Vars
   ELSE
      DO __Detail
   ENDIF
   gl_widow=.T.         && enable widow checking
   CONTINUE
ENDDO

IF gl_prntflg
   gl_fandl=.F.     && last page finished
   IF _plineno <= gn_atline
      EJECT PAGE
   ENDIF
ELSE
   DO Reset
   RETURN
ENDIF

ON PAGE

ENDPRINTJOB

DO Reset
RETURN
* EOP: C:\DBASE\TABLE12B.FRG

*-- Update summary fields and/or calculated fields.
PROCEDURE Upd_Vars
RETURN
* EOP: Upd_Vars

*-- Set flag to get out of DO WHILE loop when escape is pressed.
PROCEDURE Prnabort
gl_prntflg=.F.
RETURN
* EOP: Prnabort

PROCEDURE Pghead
?
?? ;
"Table 12.  Mineralogical data for the non-magnetic (C-3) fraction of t";
+ "he heavy-mineral-concentrate samples as determined by binocular micros";
+ "copy and x-ray";
AT 0
?

*-- Print HEADING parameter ie. REPORT FORM <name> HEADING <expC>
IF .NOT. gl_plain .AND. gn_length > 0
   ?? gc_heading FUNCTION "I;V"+LTRIM(STR(_rmargin-_lmargin))
   ?
ENDIF
?? "diffraction techniques  ...continued" AT 11
?
?
?? ;
"";
+ "";
+ "";
AT 0
?
?? "Gross Percentages of Rock-Forming and Accessory Minerals" AT 47
?
?? "Rock" AT 131
?
?? "MDNR" AT 1,;
 "Manganoan" AT 53,;
 "Forming" AT 130,;
 "Phosphatic" AT 142
?
?? "Sample" AT 0,;
 "Andalusite" AT 9,;
 "Apatite" AT 22,;
 "Corundum" AT 32,;
 "Kyanite" AT 43,;
 "diopside" AT 54,;
 "Rutile" AT 65,;
 "Sillimanite" AT 74,;
 "Sphene" AT 88,;
 "Spinel" AT 97,;
 "Tourmaline" AT 106,;
 "Zircon" AT 119,;
 "Silicate" AT 130,;
 "Shell" AT 144
?
?? "Number" AT 0,;
 "%" AT 13,;
 "%" AT 25,;
 "%" AT 35,;
 "%" AT 46,;
 "%" AT 57,;
 "%" AT 68,;
 "%" AT 79,;
 "%" AT 90,;
 "%" AT 100,;
 "%" AT 111,;
 "%" AT 122,;
 "Minerals" AT 130,;
 "Fragments" AT 142
?
?? ;
"";
+ "";
+ "";
AT 0
?
RETURN
* EOP: Pghead


PROCEDURE __Detail
IF gn_pspace < gn_atline - (_pspacing * 11 + 1)
   IF gl_widow .AND. _plineno+gn_pspace > gn_atline + 1
      EJECT PAGE
   ENDIF
ENDIF
DO Upd_Vars
?? Dnr_s_no FUNCTION "T" AT 0,;
 Andalusite FUNCTION "J" AT 12,;
 Apatite AT 24,;
 Corundum FUNCTION "J" AT 34,;
 Kyanite FUNCTION "J" AT 45,;
 Manganodio FUNCTION "J" AT 56,;
 Rutile FUNCTION "J" AT 67,;
 Sillimanit AT 78,;
 Sphene AT 89,;
 Spinel FUNCTION "J" AT 99,;
 Tourmaline FUNCTION "J" AT 110,;
 Zircon AT 121,;
 Rock_frag FUNCTION "T" AT 134,;
 Shell_frag FUNCTION "T" AT 146
?
RETURN
* EOP: __Detail


PROCEDURE Pgfoot
PRIVATE _box, _pspacing
gl_widow=.F.         && disable widow checking
_pspacing=1
?
IF .NOT. gl_plain
?? "...continued next page..." AT 131
?
?? "Note:  In the last two data columns  P = present" AT 0
ENDIF
EJECT PAGE
*-- is the page number greater than the ending page
IF _pageno > _pepage
   GOTO BOTTOM
   SKIP
   gn_level=0
ENDIF
IF .NOT. gl_plain .AND. gl_fandl
   _pspacing=gn_pspace
   DO Pghead
ENDIF
RETURN
* EOP: Pgfoot

*-- Process page break when PLAIN option is used.
PROCEDURE Pgplain
PRIVATE _box
EJECT PAGE
RETURN
* EOP: Pgplain

*-- Reset dBASE environment prior to calling report
PROCEDURE Reset
SET SPACE &gc_space.
SET TALK &gc_talk.
ON ESCAPE
ON PAGE
RETURN
* EOP: Reset

