* Program............: C:\DBASE\TABLE3.FRG
* Date...............: 6-25-92
* Versions...........: dBASE IV, Report 1.1
*
* Notes:
* ------
* Prior to running this procedure with the DO command
* it is necessary use LOCATE because the CONTINUE
* statement is in the main loop.
*
*-- Parameters
PARAMETERS gl_noeject, gl_plain, gl_summary, gc_heading, gc_extra
** The first three parameters are of type Logical.
** The fourth parameter is a string.  The fifth is extra.
PRIVATE _peject, _wrap

*-- Test for no records found
IF EOF() .OR. .NOT. FOUND()
   RETURN
ENDIF

*-- turn word wrap mode off
_wrap=.F.

IF _plength < (_pspacing * 9 + 1) + 1 + 2
   SET DEVICE TO SCREEN
   DEFINE WINDOW gw_report FROM 7,17 TO 11,62 DOUBLE
   ACTIVATE WINDOW gw_report
   @ 0,1 SAY "Increase the page length for this report."
   @ 2,1 SAY "Press any key ..."
   x=INKEY(0)
   DEACTIVATE WINDOW gw_report
   RELEASE WINDOW gw_report
   RETURN
ENDIF

_plineno=0          && set lines to zero
*-- NOEJECT parameter
IF gl_noeject
   IF _peject="BEFORE"
      _peject="NONE"
   ENDIF
   IF _peject="BOTH"
      _peject="AFTER"
   ENDIF
ENDIF

*-- Set-up environment
ON ESCAPE DO Prnabort
IF SET("TALK")="ON"
   SET TALK OFF
   gc_talk="ON"
ELSE
   gc_talk="OFF"
ENDIF
gc_space=SET("SPACE")
SET SPACE OFF
gc_time=TIME()      && system time for predefined field
gd_date=DATE()      && system date  "    "    "     "
gl_fandl=.F.        && first and last page flag
gl_prntflg=.T.      && Continue printing flag
gl_widow=.T.        && flag for checking widow bands
gn_length=LEN(gc_heading)  && store length of the HEADING
gn_level=2          && current band being processed
gn_page=_pageno     && grab current page number
gn_pspace=_pspacing && get current print spacing


*-- Set up procedure for page break
gn_atline=_plength - 1
ON PAGE AT LINE gn_atline EJECT PAGE

*-- Print Report

PRINTJOB

IF gl_plain
   ON PAGE AT LINE gn_atline DO Pgplain
ELSE
   ON PAGE AT LINE gn_atline DO Pgfoot
ENDIF

DO Pghead

gl_fandl=.T.        && first physical page started

*-- File Loop
DO WHILE FOUND() .AND. .NOT. EOF() .AND. gl_prntflg
   gn_level=0
   *-- Detail lines
   IF gl_summary
      DO Upd_Vars
   ELSE
      DO __Detail
   ENDIF
   gl_widow=.T.         && enable widow checking
   CONTINUE
ENDDO

IF gl_prntflg
ELSE
   DO Reset
   RETURN
ENDIF

ON PAGE

ENDPRINTJOB

DO Reset
RETURN
* EOP: C:\DBASE\TABLE3.FRG

*-- Update summary fields and/or calculated fields.
PROCEDURE Upd_Vars
RETURN
* EOP: Upd_Vars

*-- Set flag to get out of DO WHILE loop when escape is pressed.
PROCEDURE Prnabort
gl_prntflg=.F.
RETURN
* EOP: Prnabort

PROCEDURE Pghead
?
?

*-- Print HEADING parameter ie. REPORT FORM <name> HEADING <expC>
IF .NOT. gl_plain .AND. gn_length > 0
   ?? gc_heading FUNCTION "I;V"+LTRIM(STR(_rmargin-_lmargin))
   ?
ENDIF
?? ;
"Table 3.  Location information, surface ownership, and gravel pit acti";
+ "vity status for the test and pilot study sample sites  ...continued";
AT 0
?
?
?? ;
"";
+ "";
+ "";
AT 0
?
?? " MDNR" AT 0,;
 "USGS" AT 12,;
 "Gravel Pit" AT 119
?
?? "Sample" AT 0,;
 "Sample" AT 11,;
 "USGS" AT 38,;
 "Surface" AT 107,;
 "Activity" AT 120
?
?? "Number" AT 0,;
 "Number" AT 11,;
 "County" AT 23,;
 "Quadrangle" AT 35,;
 "Latitude" AT 55,;
 "Longitude" AT 67,;
 "TWP" AT 80,;
 "RNG" AT 84,;
 "SEC" AT 88,;
 "Location" AT 94,;
 "Ownership" AT 106,;
 "Status" AT 121,;
 "Remarks" AT 144
?
?? ;
"";
+ "";
+ "";
AT 0
?
RETURN
* EOP: Pghead


PROCEDURE __Detail
IF gn_pspace < gn_atline - (_pspacing * 9 + 1)
   IF gl_widow .AND. _plineno+gn_pspace > gn_atline + 1
      EJECT PAGE
   ENDIF
ENDIF
DO Upd_Vars
?? Dnr_s_no FUNCTION "T" PICTURE "XXXXXXXX" AT 0,;
 Usgs_s_no FUNCTION "T" PICTURE "XXXXXXXXX" AT 10,;
 County FUNCTION "T" PICTURE "XXXXXXXXXX" AT 21,;
 Usgs_quad FUNCTION "T" AT 33,;
 Latitude FUNCTION "T" AT 55,;
 Longitude FUNCTION "T" AT 67,;
 Township FUNCTION "J" AT 80,;
 Range FUNCTION "T" AT 84,;
 Range_dir FUNCTION "T" ,;
 Section FUNCTION "J" AT 88,;
 Se_sw_nwne FUNCTION "J" AT 93,;
 Surf_owner FUNCTION "T" PICTURE "XXXXXXXXXX" AT 106,;
 Status FUNCTION "T" AT 118,;
 Remarks_s FUNCTION "V18" AT 141
?
RETURN
* EOP: __Detail


PROCEDURE Pgfoot
PRIVATE _box
gl_widow=.F.         && disable widow checking
EJECT PAGE
*-- is the page number greater than the ending page
IF _pageno > _pepage
   GOTO BOTTOM
   SKIP
   gn_level=0
ENDIF
IF .NOT. gl_plain .AND. gl_fandl
   _pspacing=gn_pspace
   DO Pghead
ENDIF
RETURN
* EOP: Pgfoot

*-- Process page break when PLAIN option is used.
PROCEDURE Pgplain
PRIVATE _box
EJECT PAGE
RETURN
* EOP: Pgplain

*-- Reset dBASE environment prior to calling report
PROCEDURE Reset
SET SPACE &gc_space.
SET TALK &gc_talk.
ON ESCAPE
ON PAGE
RETURN
* EOP: Reset

