* Program............: C:\DBASE\TABLE13.FRG
* Date...............: 7-01-92
* Versions...........: dBASE IV, Report 1.1
*
* Notes:
* ------
* Prior to running this procedure with the DO command
* it is necessary use LOCATE because the CONTINUE
* statement is in the main loop.
*
*-- Parameters
PARAMETERS gl_noeject, gl_plain, gl_summary, gc_heading, gc_extra
** The first three parameters are of type Logical.
** The fourth parameter is a string.  The fifth is extra.
PRIVATE _peject, _wrap

*-- Test for no records found
IF EOF() .OR. .NOT. FOUND()
   RETURN
ENDIF

*-- turn word wrap mode off
_wrap=.F.

IF _plength < (_pspacing * 9 + 1) + 1 + 2
   SET DEVICE TO SCREEN
   DEFINE WINDOW gw_report FROM 7,17 TO 11,62 DOUBLE
   ACTIVATE WINDOW gw_report
   @ 0,1 SAY "Increase the page length for this report."
   @ 2,1 SAY "Press any key ..."
   x=INKEY(0)
   DEACTIVATE WINDOW gw_report
   RELEASE WINDOW gw_report
   RETURN
ENDIF

_plineno=0          && set lines to zero
*-- NOEJECT parameter
IF gl_noeject
   IF _peject="BEFORE"
      _peject="NONE"
   ENDIF
   IF _peject="BOTH"
      _peject="AFTER"
   ENDIF
ENDIF

*-- Set-up environment
ON ESCAPE DO Prnabort
IF SET("TALK")="ON"
   SET TALK OFF
   gc_talk="ON"
ELSE
   gc_talk="OFF"
ENDIF
gc_space=SET("SPACE")
SET SPACE OFF
gc_time=TIME()      && system time for predefined field
gd_date=DATE()      && system date  "    "    "     "
gl_fandl=.F.        && first and last page flag
gl_prntflg=.T.      && Continue printing flag
gl_widow=.T.        && flag for checking widow bands
gn_length=LEN(gc_heading)  && store length of the HEADING
gn_level=2          && current band being processed
gn_page=_pageno     && grab current page number
gn_pspace=_pspacing && get current print spacing


*-- Set up procedure for page break
gn_atline=_plength - 1
ON PAGE AT LINE gn_atline EJECT PAGE

*-- Print Report

PRINTJOB

IF gl_plain
   ON PAGE AT LINE gn_atline DO Pgplain
ELSE
   ON PAGE AT LINE gn_atline DO Pgfoot
ENDIF

DO Pghead

gl_fandl=.T.        && first physical page started

*-- File Loop
DO WHILE FOUND() .AND. .NOT. EOF() .AND. gl_prntflg
   gn_level=0
   *-- Detail lines
   IF gl_summary
      DO Upd_Vars
   ELSE
      DO __Detail
   ENDIF
   gl_widow=.T.         && enable widow checking
   CONTINUE
ENDDO

IF gl_prntflg
ELSE
   DO Reset
   RETURN
ENDIF

ON PAGE

ENDPRINTJOB

DO Reset
RETURN
* EOP: C:\DBASE\TABLE13.FRG

*-- Update summary fields and/or calculated fields.
PROCEDURE Upd_Vars
RETURN
* EOP: Upd_Vars

*-- Set flag to get out of DO WHILE loop when escape is pressed.
PROCEDURE Prnabort
gl_prntflg=.F.
RETURN
* EOP: Prnabort

PROCEDURE Pghead
?
?? ;
"Table 13.  Quantitative mineralogical data for the paramagnetic (C-2) ";
+ "fraction of the heavy-mineral-concentrate test study samples as determ";
+ "ined by point";
AT 0
?

*-- Print HEADING parameter ie. REPORT FORM <name> HEADING <expC>
IF .NOT. gl_plain .AND. gn_length > 0
   ?? gc_heading FUNCTION "I;V"+LTRIM(STR(_rmargin-_lmargin))
   ?
ENDIF
?? "count analysis" AT 11
?
?
?? ;
"";
+ "";
+ "";
AT 0
?
?? "MDNR" AT 1,;
 "Iron" AT 70,;
 "Rock" AT 81
?
?? "Sample" AT 0,;
 "Hornblende" AT 9,;
 "Olivine" AT 21,;
 "Epidote" AT 30,;
 "Pyroxene" AT 39,;
 "Garnet" AT 50,;
 "Opaques" AT 59,;
 "Formation" AT 68,;
 "Fragments" AT 79,;
 "Feldspar" AT 91,;
 "Sphene" AT 101,;
 "Biotite" AT 109,;
 "Staurolite" AT 118,;
 "Actinolite" AT 130,;
 "Tourmaline" AT 142,;
 "Quartz" AT 154
?
?? "Number" AT 0,;
 "%" AT 13,;
 "%" AT 24,;
 "%" AT 33,;
 "%" AT 42,;
 "%" AT 52,;
 "%" AT 62,;
 "%" AT 72,;
 "%" AT 83,;
 "%" AT 95,;
 "%" AT 104,;
 "%" AT 112,;
 "%" AT 122,;
 "%" AT 134,;
 "%" AT 146,;
 "%" AT 157
?
?? ;
"";
+ "";
+ "";
AT 0
?
RETURN
* EOP: Pghead


PROCEDURE __Detail
IF gn_pspace < gn_atline - (_pspacing * 9 + 1)
   IF gl_widow .AND. _plineno+gn_pspace > gn_atline + 1
      EJECT PAGE
   ENDIF
ENDIF
DO Upd_Vars
?? Dnr_s_no FUNCTION "T" AT 0,;
 Hornblende AT 11,;
 Olivine AT 22,;
 Epidote AT 31,;
 Pyroxene AT 40,;
 Garnet AT 50,;
 Opaques AT 60,;
 Iron_fm AT 70,;
 Met_ign_rk AT 81,;
 Feldspar AT 93,;
 Sphene AT 102,;
 Biotite AT 110,;
 Staurolite AT 120,;
 Actinolite AT 132,;
 Tourmaline AT 144,;
 Quartz AT 155
?
RETURN
* EOP: __Detail


PROCEDURE Pgfoot
PRIVATE _box
gl_widow=.F.         && disable widow checking
EJECT PAGE
*-- is the page number greater than the ending page
IF _pageno > _pepage
   GOTO BOTTOM
   SKIP
   gn_level=0
ENDIF
IF .NOT. gl_plain .AND. gl_fandl
   _pspacing=gn_pspace
   DO Pghead
ENDIF
RETURN
* EOP: Pgfoot

*-- Process page break when PLAIN option is used.
PROCEDURE Pgplain
PRIVATE _box
EJECT PAGE
RETURN
* EOP: Pgplain

*-- Reset dBASE environment prior to calling report
PROCEDURE Reset
SET SPACE &gc_space.
SET TALK &gc_talk.
ON ESCAPE
ON PAGE
RETURN
* EOP: Reset

