* Program............: C:\DBASE\TABLE9C.FRG
* Date...............: 6-30-92
* Versions...........: dBASE IV, Report 1.1
*
* Notes:
* ------
* Prior to running this procedure with the DO command
* it is necessary use LOCATE because the CONTINUE
* statement is in the main loop.
*
*-- Parameters
PARAMETERS gl_noeject, gl_plain, gl_summary, gc_heading, gc_extra
** The first three parameters are of type Logical.
** The fourth parameter is a string.  The fifth is extra.
PRIVATE _peject, _wrap

*-- Test for no records found
IF EOF() .OR. .NOT. FOUND()
   RETURN
ENDIF

*-- turn word wrap mode off
_wrap=.F.

IF _plength < (_pspacing * 10 + 1) + (_pspacing * 5 + 1) + 2
   SET DEVICE TO SCREEN
   DEFINE WINDOW gw_report FROM 7,17 TO 11,62 DOUBLE
   ACTIVATE WINDOW gw_report
   @ 0,1 SAY "Increase the page length for this report."
   @ 2,1 SAY "Press any key ..."
   x=INKEY(0)
   DEACTIVATE WINDOW gw_report
   RELEASE WINDOW gw_report
   RETURN
ENDIF

_plineno=0          && set lines to zero
*-- NOEJECT parameter
IF gl_noeject
   IF _peject="BEFORE"
      _peject="NONE"
   ENDIF
   IF _peject="BOTH"
      _peject="AFTER"
   ENDIF
ENDIF

*-- Set-up environment
ON ESCAPE DO Prnabort
IF SET("TALK")="ON"
   SET TALK OFF
   gc_talk="ON"
ELSE
   gc_talk="OFF"
ENDIF
gc_space=SET("SPACE")
SET SPACE OFF
gc_time=TIME()      && system time for predefined field
gd_date=DATE()      && system date  "    "    "     "
gl_fandl=.F.        && first and last page flag
gl_prntflg=.T.      && Continue printing flag
gl_widow=.T.        && flag for checking widow bands
gn_length=LEN(gc_heading)  && store length of the HEADING
gn_level=2          && current band being processed
gn_page=_pageno     && grab current page number
gn_pspace=_pspacing && get current print spacing


*-- Set up procedure for page break
gn_atline=_plength - (_pspacing * 5 + 1)
ON PAGE AT LINE gn_atline EJECT PAGE

*-- Print Report

PRINTJOB

IF gl_plain
   ON PAGE AT LINE gn_atline DO Pgplain
ELSE
   ON PAGE AT LINE gn_atline DO Pgfoot
ENDIF

DO Pghead

gl_fandl=.T.        && first physical page started

*-- File Loop
DO WHILE FOUND() .AND. .NOT. EOF() .AND. gl_prntflg
   gn_level=0
   *-- Detail lines
   IF gl_summary
      DO Upd_Vars
   ELSE
      DO __Detail
   ENDIF
   gl_widow=.T.         && enable widow checking
   CONTINUE
ENDDO

IF gl_prntflg
   gl_fandl=.F.     && last page finished
   IF _plineno <= gn_atline
      EJECT PAGE
   ENDIF
ELSE
   DO Reset
   RETURN
ENDIF

ON PAGE

ENDPRINTJOB

DO Reset
RETURN
* EOP: C:\DBASE\TABLE9C.FRG

*-- Update summary fields and/or calculated fields.
PROCEDURE Upd_Vars
RETURN
* EOP: Upd_Vars

*-- Set flag to get out of DO WHILE loop when escape is pressed.
PROCEDURE Prnabort
gl_prntflg=.F.
RETURN
* EOP: Prnabort

PROCEDURE Pghead
?
?

*-- Print HEADING parameter ie. REPORT FORM <name> HEADING <expC>
IF .NOT. gl_plain .AND. gn_length > 0
   ?? gc_heading FUNCTION "I;V"+LTRIM(STR(_rmargin-_lmargin))
   ?
ENDIF
?? ;
"Table 9.  Analytical data for the nonmagnetic (C-3) fraction of the he";
+ "avy-mineral-concentrate samples as determined by semiquantitative emis";
+ "sion spectroscopy";
AT 0
?
?? " ...continued" AT 10
?
?
?? ;
"";
+ "";
AT 0
?
?? "MDNR" AT 1
?
?? "Sample" AT 0,;
 "Sr" AT 11,;
 "Th" AT 22,;
 "V" AT 36,;
 "W" AT 47,;
 "Y" AT 58,;
 "Zn" AT 67,;
 "Zr" AT 79
?
?? "Number" AT 0,;
 "ppm" AT 11,;
 "ppm" AT 22,;
 "ppm" AT 35,;
 "ppm" AT 46,;
 "ppm" AT 57,;
 "ppm" AT 67,;
 "ppm" AT 79
?
?? ;
"";
+ "";
AT 0
?
RETURN
* EOP: Pghead


PROCEDURE __Detail
IF gn_pspace < gn_atline - (_pspacing * 10 + 1)
   IF gl_widow .AND. _plineno+gn_pspace > gn_atline + 1
      EJECT PAGE
   ENDIF
ENDIF
DO Upd_Vars
?? Dnr_s_no FUNCTION "T" AT 0,;
 Sr_ppm__c3 AT 10,;
 Th_ppm__c3 AT 22,;
 V_ppm__c3 AT 34,;
 W_ppm__c3 AT 45,;
 Y_ppm__c3 AT 56,;
 Zn_ppm__c3 AT 66,;
 Zr_ppm__c3 AT 78
?
RETURN
* EOP: __Detail


PROCEDURE Pgfoot
PRIVATE _box, _pspacing
gl_widow=.F.         && disable widow checking
_pspacing=1
?
IF .NOT. gl_plain
?
?? ;
"Note:  The following elements were not detected at the lower determina";
+ "tion limit shown:  Cd (50 ppm), Ge (20 ppm), Pd (5 ppm), and Pt (20 pp";
+ "m).";
AT 0
?
?? ;
"N = element was not detected at the lower determination limit shown;  ";
+ "  L = element observed, but was below the lower determination limit sh";
+ "own;";
AT 0
?
?? ;
"G = element observed, but was above the upper determination limit show";
+ "n";
AT 0
?
?? ;
"*  23967 = concentrate sample;  23969 = pre-glacial alluvium sample;  ";
+ "23971 = active stream sediment sample";
AT 0
ENDIF
EJECT PAGE
*-- is the page number greater than the ending page
IF _pageno > _pepage
   GOTO BOTTOM
   SKIP
   gn_level=0
ENDIF
IF .NOT. gl_plain .AND. gl_fandl
   _pspacing=gn_pspace
   DO Pghead
ENDIF
RETURN
* EOP: Pgfoot

*-- Process page break when PLAIN option is used.
PROCEDURE Pgplain
PRIVATE _box
EJECT PAGE
RETURN
* EOP: Pgplain

*-- Reset dBASE environment prior to calling report
PROCEDURE Reset
SET SPACE &gc_space.
SET TALK &gc_talk.
ON ESCAPE
ON PAGE
RETURN
* EOP: Reset

