* Program............: C:\DBASE\TABLE16C.FRG
* Date...............: 7-02-92
* Versions...........: dBASE IV, Report 1.1
*
* Notes:
* ------
* Prior to running this procedure with the DO command
* it is necessary use LOCATE because the CONTINUE
* statement is in the main loop.
*
*-- Parameters
PARAMETERS gl_noeject, gl_plain, gl_summary, gc_heading, gc_extra
** The first three parameters are of type Logical.
** The fourth parameter is a string.  The fifth is extra.
PRIVATE _peject, _wrap

*-- Test for no records found
IF EOF() .OR. .NOT. FOUND()
   RETURN
ENDIF

*-- turn word wrap mode off
_wrap=.F.

IF _plength < (_pspacing * 9 + 1) + (_pspacing * 4 + 1) + 2
   SET DEVICE TO SCREEN
   DEFINE WINDOW gw_report FROM 7,17 TO 11,62 DOUBLE
   ACTIVATE WINDOW gw_report
   @ 0,1 SAY "Increase the page length for this report."
   @ 2,1 SAY "Press any key ..."
   x=INKEY(0)
   DEACTIVATE WINDOW gw_report
   RELEASE WINDOW gw_report
   RETURN
ENDIF

_plineno=0          && set lines to zero
*-- NOEJECT parameter
IF gl_noeject
   IF _peject="BEFORE"
      _peject="NONE"
   ENDIF
   IF _peject="BOTH"
      _peject="AFTER"
   ENDIF
ENDIF

*-- Set-up environment
ON ESCAPE DO Prnabort
IF SET("TALK")="ON"
   SET TALK OFF
   gc_talk="ON"
ELSE
   gc_talk="OFF"
ENDIF
gc_space=SET("SPACE")
SET SPACE OFF
gc_time=TIME()      && system time for predefined field
gd_date=DATE()      && system date  "    "    "     "
gl_fandl=.F.        && first and last page flag
gl_prntflg=.T.      && Continue printing flag
gl_widow=.T.        && flag for checking widow bands
gn_length=LEN(gc_heading)  && store length of the HEADING
gn_level=2          && current band being processed
gn_page=_pageno     && grab current page number
gn_pspace=_pspacing && get current print spacing


*-- Set up procedure for page break
gn_atline=_plength - (_pspacing * 4 + 1)
ON PAGE AT LINE gn_atline EJECT PAGE

*-- Print Report

PRINTJOB

IF gl_plain
   ON PAGE AT LINE gn_atline DO Pgplain
ELSE
   ON PAGE AT LINE gn_atline DO Pgfoot
ENDIF

DO Pghead

gl_fandl=.T.        && first physical page started

*-- File Loop
DO WHILE FOUND() .AND. .NOT. EOF() .AND. gl_prntflg
   gn_level=0
   *-- Detail lines
   IF gl_summary
      DO Upd_Vars
   ELSE
      DO __Detail
   ENDIF
   gl_widow=.T.         && enable widow checking
   CONTINUE
ENDDO

IF gl_prntflg
   gl_fandl=.F.     && last page finished
   IF _plineno <= gn_atline
      EJECT PAGE
   ENDIF
ELSE
   DO Reset
   RETURN
ENDIF

ON PAGE

ENDPRINTJOB

DO Reset
RETURN
* EOP: C:\DBASE\TABLE16C.FRG

*-- Update summary fields and/or calculated fields.
PROCEDURE Upd_Vars
RETURN
* EOP: Upd_Vars

*-- Set flag to get out of DO WHILE loop when escape is pressed.
PROCEDURE Prnabort
gl_prntflg=.F.
RETURN
* EOP: Prnabort

PROCEDURE Pghead
?
?? ;
"Table 16.  Mineralogical remarks and chemical composition of miscellan";
+ "eous mineral grains identified in the heavy-mineral-concentrate test s";
+ "tudy samples by";
AT 0
?

*-- Print HEADING parameter ie. REPORT FORM <name> HEADING <expC>
IF .NOT. gl_plain .AND. gn_length > 0
   ?? gc_heading FUNCTION "I;V"+LTRIM(STR(_rmargin-_lmargin))
   ?
ENDIF
?? "electron microprobe analysis  ...continued" AT 11
?
?
?? ;
"";
+ "";
+ "";
AT 0
?
?? "MDNR" AT 1,;
 "Weight % of Oxides" AT 70
?
?? "Sample" AT 0
?
?? "Number" AT 0,;
 "Al" AT 9,;
 "2" STYLE "L" ,;
 "O" ,;
 "3" STYLE "L" ,;
 "BaO" AT 18,;
 "CaO" AT 26,;
 "CeO" AT 33,;
 "2" STYLE "L" ,;
 "CuO" AT 42,;
 "Dy" AT 49,;
 "2" STYLE "L" ,;
 "O" ,;
 "3" STYLE "L" ,;
 "Er" AT 57,;
 "2" STYLE "L" ,;
 "O" 
?? "3" STYLE "L" ,;
 "FeO" AT 66,;
 "Gd" AT 73,;
 "2" STYLE "L" ,;
 "O" ,;
 "3" STYLE "L" ,;
 "HfO" AT 81,;
 "2" STYLE "L" ,;
 "La" AT 89,;
 "2" STYLE "L" ,;
 "O" ,;
 "3" STYLE "L" ,;
 "MnO" AT 98,;
 "Nb" AT 105,;
 "2" STYLE "L" ,;
 "O" 
?? "5" STYLE "L" ,;
 "Nd" AT 113,;
 "2" STYLE "L" ,;
 "O" ,;
 "3" STYLE "L" ,;
 "P" AT 121,;
 "2" STYLE "L" ,;
 "O" ,;
 "5" STYLE "L" ,;
 "PbO" AT 130,;
 "PrO" AT 137,;
 "2" STYLE "L" ,;
 "SeO" AT 145,;
 "2" STYLE "L" ,;
 "SiO" AT 153,;
 "2" STYLE "L" 
?
?? ;
"";
+ "";
+ "";
STYLE "L" AT 0
?
RETURN
* EOP: Pghead


PROCEDURE __Detail
IF gn_pspace < gn_atline - (_pspacing * 9 + 1)
   IF gl_widow .AND. _plineno+gn_pspace > gn_atline + 1
      EJECT PAGE
   ENDIF
ENDIF
DO Upd_Vars
?? Dnr_s_no FUNCTION "T" AT 0,;
 Al203 AT 9,;
 Bao AT 17,;
 Cao AT 25,;
 Ceo2 AT 33,;
 Cuo AT 41,;
 Dy2o3 AT 49,;
 Er2o3 AT 57,;
 Feo AT 65,;
 Gd2o3 AT 73,;
 Hfo2 AT 81,;
 La2o3 AT 89,;
 Mno AT 97,;
 Nb2o5 AT 105,;
 Nd2o3 AT 113,;
 P2o5 AT 121,;
 Pbo AT 129
?? Pro2 AT 137,;
 Seo2 AT 145,;
 Sio2 AT 153
?
RETURN
* EOP: __Detail


PROCEDURE Pgfoot
PRIVATE _box, _pspacing
gl_widow=.F.         && disable widow checking
_pspacing=1
?
IF .NOT. gl_plain
?
?? "...continued next page..." AT 134
?
?
?? ;
"Note:  Within a sample, separate analyses are identified by a lower-ca";
+ "se letter following the sample number.";
AT 0
ENDIF
EJECT PAGE
*-- is the page number greater than the ending page
IF _pageno > _pepage
   GOTO BOTTOM
   SKIP
   gn_level=0
ENDIF
IF .NOT. gl_plain .AND. gl_fandl
   _pspacing=gn_pspace
   DO Pghead
ENDIF
RETURN
* EOP: Pgfoot

*-- Process page break when PLAIN option is used.
PROCEDURE Pgplain
PRIVATE _box
EJECT PAGE
RETURN
* EOP: Pgplain

*-- Reset dBASE environment prior to calling report
PROCEDURE Reset
SET SPACE &gc_space.
SET TALK &gc_talk.
ON ESCAPE
ON PAGE
RETURN
* EOP: Reset

